<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\News as NewsModel;

class NetController extends Controller
{
    public function __construct()
    {
    }

    public function index()
    {
        return view('admin.net.net');
    }

    public function show($id)
    {
        return ['code' => 0, 'data' => get_select(DB::table('net')->find($id))];
    }

    public function render()
    {
        $data = get_select(DB::table('net')->find(1));
        $data['lianjie_name'] = explode('@', $data['lianjie_name']);
        $data['lianjie'] = explode('@', $data['lianjie']);

        $news = get_select(NewsModel::where('status', 2)->get());
        array_map('unlink', glob(public_path('detail/*')));
        foreach ($news as $key => $vo) {
            @file_put_contents(public_path('detail/' . $vo['id'] . '.html'), view('admin.news.news_detail', ['net' => $data, 'detail' => $vo])->render());
        }
        $ds = glob(public_path('detail/*'));
        usort($ds, function ($a, $b) {
            preg_match('/(\d+)\.html/', $a, $m);
            preg_match('/(\d+)\.html/', $b, $n);
            return $m[1] > $n[1] ? -1 : 1;
        });
        $res = [];
        while (!empty($s = array_splice($ds, 0, 10))) {
            $res[] = $s;
        }
        $newsData = ['list' => $res, 'titles' => array_column($news, 'title', 'id'), 'times' => array_column($news, 'created_at', 'id')];
        view()->share(['data' => array_merge($data, $newsData)]);
        $fillables = [];
        foreach (glob(base_path('resources/views/web/*')) as $vo) {
            $e = explode('.', basename($vo));
            $name = $e[0];
            $fillables[$name . '.html'] = 'web.' . $name;
        }
        foreach ($fillables as $key => $vo) {
            @file_put_contents(public_path($key), view($vo)->render());
        }
        return ['code' => 0];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update($id)
    {
        $fillable = [
            'title',
            'keywords',
            'description',
            'open_bd',
            'bd_image',
            'bd_link',
            'open_foot',
            'banquan',
            'beian',
            'lianjie',
            'lianjie_name',
        ];
        $params = request()->only($fillable);
        $params['open_bd'] = $params['open_bd'] === 'true';
        $params['open_foot'] = $params['open_foot'] === 'true';
        try {
            DB::table('net')->where('id', $id)->update($params);
            $this->render();
            return ['code' => 0];
        } catch (\Exception $e) {
            return ['code' => -1];
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function tt()
    {
        $fillables = [];
        foreach (glob(base_path('public/*.html')) as $vo) {
            $e = explode('.', basename($vo));
            $name = $e[0];
            $fillables[$vo] = $name . '.blade.php';
        }
        foreach ($fillables as $key => $vo) {
            @file_put_contents(base_path('resources/views/web/' . $vo), file_get_contents($key));
        }
    }
}
