class AdminBase {
    constructor() {
        'use strict';
    }

    // 移动端
    static isMobile() {
        let Agents = ["Android", "iPhone", "SymbianOS", "Windows Phone", "iPod"];
        for (let v = 0; v < Agents.length; v++) {
            if (navigator.userAgent.indexOf(Agents[v]) > 0) {
                return true;
            }
        }
        return $(window).width() < 768;
    }

    static isMs() {
        return /MSIE|EDGE|TRIDENT/i.test(navigator.userAgent);
    }

    // 遮罩层滚动穿刺修复
    static fixModalScroll() {
        let scrollTop;
        return {
            afterOpen: function () {
                scrollTop = document.scrollingElement.scrollTop;
                document.body.classList.add('modal-open');
                document.body.style.top = -scrollTop + 'px';
            },
            beforeClose: function () {
                document.body.classList.remove('modal-open');
                document.scrollingElement.scrollTop = scrollTop;
            }
        };
    }

    static confirm(obj = {}, extend = {}) {
        //弹出框
        let id = `dialog_${new Date().getTime()}`,
            types = ['info', 'warning', 'success', 'danger'],
            _option = Object.assign({}, obj, extend),
            option = {
                type: _option.type && types.includes(_option.type) ? _option.type : 'info',
                title: _option.title || '信息提示',
                msg: _option.msg || '',
                btnSubmit: _option.btnSubmit === true,
                btnCancel: _option.btnCancel === true,
                btnClose: _option.btnClose === true,
                callback: $.isFunction(_option.callback) ? _option.callback : false,
                timeout: _option.timeout || 0,
            };
        Vue.component('alert-dialog', {
            data: function () {
                return {
                    styleObj: {
                        width: AdminBase.isMobile() ? '18rem' : '25rem',
                        height: AdminBase.isMobile() ? '10rem' : '15rem',
                        top: 0,
                        left: 0,
                    },
                    classObj: {
                        'alert-info': option.type === 'info',
                        'alert-warning': option.type === 'warning',
                        'alert-success': option.type === 'success',
                        'alert-danger': option.type === 'danger'
                    },
                    classI: {
                        'fa-info-circle': option.type === 'info',
                        'fa-warning': option.type === 'warning',
                        'fa-check-square-o': option.type === 'success',
                        'fa-minus-circle': option.type === 'danger',
                    },
                    is_open: false,
                    btnSubmit: option.btnSubmit,
                    btnCancel: option.btnCancel,
                    btnClose: option.btnClose,
                    scrollEvent: '',

                };
            },
            mounted: function () {
                this.justifyPosition();
                this.is_open && (window.onresize = this.justifyPosition);
                this.scrollEvent = AdminBase.fixModalScroll();
                this.scrollEvent.afterOpen();
            },
            methods: {
                justifyPosition: function () {
                    this.styleObj.top = $('.w-cover').height() / 2 - $('.w-cover > div').outerHeight() / 2 + 'px';
                    this.styleObj.left = $('.w-cover').width() / 2 - $('.w-cover > div').outerWidth() / 2 + 'px';
                    this.is_open = true;
                },
                callback: function () {
                    option.callback && setTimeout(option.callback, option.timeout);
                    this.cancel();
                    return false;
                },
                cancel: function () {
                    this.scrollEvent.beforeClose();
                    let _this = this;
                    $(`#${id}`).fadeOut(400, function () {
                        $('body').find(`#${id}`).remove();
                        _this.is_open = false;
                    });
                }
            },
            template: `<div class="alert alert-dismissible w-dialog animated bounceInDown" :style="styleObj" :class="classObj">
                          <a class="close" data-dismiss="alert" aria-hidden="true" v-if="btnClose" @click="cancel">×</a>
                          <h5><i class="icon fa" :class="classI"></i> ${option.title}</h5>
                          <p>${option.msg}</p>
                          <div class="confirm_btn">
                              <span class="alert-btn-submit" v-if="btnSubmit" @click="callback">确定</span>
                              <span class="alert-btn-cancel" v-if="btnCancel" @click="cancel">取消</span>
                          </div>
                       </div>`
        });
        $('body').append(`<div id=${id} class="w-cover"><alert-dialog></alert-dialog></div>`);
        new Vue({
            el: `#${id}`
        });
        $(`#${id}`).fadeIn(400);
        return false;
    }

    static success(msg, callback, timeout) {
        let params = {
                msg: msg,
                callback: callback,
                timeout: timeout
            },
            extend = {
                type: 'success',
                btnSubmit: true
            };
        return AdminBase.confirm(params, extend);
    }

    static fail(msg, callback, timeout) {
        let params = {
                msg: msg,
                callback: callback,
                timeout: timeout
            },
            extend = {
                type: 'warning',
                btnSubmit: true,
                btnCancel: true,
                btnClose: true,
            };
        return AdminBase.confirm(params, extend)
    }

    static warn(msg, callback, timeout) {
        let params = {
                msg: msg,
                callback: callback,
                timeout: timeout
            },
            extend = {
                type: 'info',
                btnSubmit: true,
                btnCancel: true,
                btnClose: true,
            };
        return AdminBase.confirm(params, extend)
    }

    static danger(msg, callback, timeout) {
        let params = {
                title: '非法操作',
                msg: msg,
                callback: callback,
                timeout: timeout
            },
            extend = {
                type: 'danger',
                btnSubmit: true,
            };
        return AdminBase.confirm(params, extend)
    }

    static pagination(wrap, object = {}) {
        let bats = ['total', 'current_page', 'last_page', 'callback'];
        if (!wrap || !bats.every((x) => {
            return object[x] !== 'undefined';
        })) {
            return false;
        }
        let nums = [],
            html = `<ul class="pagination pagination-sm m-0 float-right table_pagination">
                        <li class="page-item page-link">共${object.total}条</li>
                        <li class="page-item page-link">«</li>
                    `;
        if (object.last_page <= 11) {
            for (let i = 1; i <= object.last_page; i++) {
                nums.push(i);
            }
        } else {
            if (object.current_page <= 6) {
                nums = [1, 2, 3, 4, 5, 6, 7, '...', object.last_page - 2, object.last_page - 1, object.last_page];
            } else if (object.current_page < object.last_page - 2) {
                if (object.last_page - object.current_page <= 4) {
                    nums = [1, 2, 3, 4, 5, '...', object.last_page - 4, object.last_page - 3, object.last_page - 2, object.last_page - 1, object.last_page]
                } else {
                    nums = [1, 2, 3, '...', object.current_page - 1, object.current_page, object.current_page + 1, '...', object.last_page - 2, object.last_page - 1, object.last_page]
                }
            } else {
                nums = [1, 2, 3, 4, 5, '...', object.last_page - 5, object.last_page - 4, object.last_page - 3, object.last_page - 2, object.last_page - 1, object.last_page]
            }
        }
        nums.map(function (x) {
            html += `<li class="page-item page-link ${x === object.current_page ? 'page-actived' : ''}">${x}</li>`;
        });
        html += `<li class="page-item page-link">»</li></ul>`;
        wrap.off().on('click', '.page-link', function () {
            let symbol = $(this).text(),
                _symbol = symbol | 0;
            if (_symbol > 0 && _symbol !== object.current_page) {
                return object.callback(symbol);
            }
            if (symbol === '...') {
                let num = $(this).prev().text() | 0;
                return object.callback(num);
            }
            if (symbol === '«') {
                return object.current_page === 1 ? false : object.callback(object.current_page - 1);
            }
            if (symbol === '»') {
                return object.current_page === object.last_page ? false : object.callback(object.current_page + 1);
            }
        });
        wrap.html(html);
    }

    static csrf_token() {
        return $('meta[name="csrf-token"]').attr('content');
    }

    static tools() {
        return {
            trim: function (string) {
                return string.replace(/^[\s\t\n\r]*(.*?)[\s\t\n\r]*$/, '$1');
            }
        }
    }
}