new (class UserApp extends AdminBase {
    constructor() {
        super();
        this.init();
    }

    init() {
        const userApp = new Vue({
                el: "#user-table",
                data: {
                    total: 0,
                    list: {}
                },
                created: function () {
                    this.get_list();
                },
                methods: {
                    get_list: function (page = 1, username = '') {
                        let that = this;
                        username = encodeURIComponent(username);
                        $.getJSON(`/user/user?username=${username}&page=${page}&is_ajax=1`, function (data) {
                            that.total = data.total;
                            that.list = data.list;
                            AdminBase.pagination($('#user-page-wrap'), {
                                total: data.total,
                                current_page: data.current_page,
                                last_page: data.last_page,
                                callback: that.get_list,
                            });
                        });
                    },
                    del: (id) => {
                        return id ? AdminBase.warn('确认删除此用户吗?', () => {
                                $.ajax({
                                    url: `/user/user/${id}`,
                                    type: 'delete',
                                    headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                                    success: (data) => {
                                        return data.code === 0 ? AdminBase.success('删除成功', () => {
                                            location.href = '/user/user/'
                                        }, 1000) : AdminBase.fail(data.msg || '删除失败')
                                    }
                                });
                                return false;
                            }
                        ) : AdminBase.fail('错误操作！');
                    }
                },
                computed: {
                    renderList: function () {
                        let items = this.list;
                        for (let i in items) {
                            let role = items[i].roles;
                            if (role) {
                                role = role.split(',');
                                role = role.length <= 3 ? role : role.splice(0, 3);
                                items[i].roles = role.map(function (v) {
                                    return `<span>${v}</span>`
                                }).join('');
                            }
                            items[i].statusShow = items[i].status === 1
                                ? '<span class="shadow_span bg-abnormal">冻结</span>'
                                : '<span class="shadow_span bg-normal">正常</span>';
                        }
                        return items;
                    }
                }
            }),
            roleApp = new Vue({
                el: "#role-table",
                data: {
                    total: 0,
                    list: {}
                },
                created: function () {
                    this.get_list();
                },
                methods: {
                    get_list: function (page = 1, name = '') {
                        let that = this;
                        name = encodeURIComponent(name);
                        $.getJSON(`/role?name=${name}&page=${page}`, function (data) {
                            data = data.data;
                            that.total = data.total;
                            that.list = data.list;
                            AdminBase.pagination($('#role-page-wrap'), {
                                total: data.total,
                                current_page: data.current_page,
                                last_page: data.last_page,
                                callback: that.get_list,
                            });
                        });
                    },
                    del: (id) => {
                        return id ? AdminBase.warn('确认删除此角色吗?', () => {
                                $.ajax({
                                    url: `/role/${id}`,
                                    type: 'delete',
                                    headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                                    success: (data) => {
                                        return data.code === 0 ? AdminBase.success('删除成功', () => {
                                            location.href = '/user/user/'
                                        }, 1000) : AdminBase.fail(data.msg || '删除失败')
                                    }
                                });
                                return false;
                            }
                        ) : AdminBase.fail('错误操作！');
                    }
                }
            }),
            permissionApp = new Vue({
                el: '#permission_ul',
                data: {
                    permissions: {},
                    lockedStyle: {
                        backgroundColor: '#f6c524'
                    },
                    unlockStyle: {
                        backgroundColor: '#F5F5DC'
                    }
                },
                mounted: function () {
                    let _this = this;
                    $.getJSON('/permission', function (data) {
                        if (!data || data.code !== 0) {
                            return AdminBase.fail((data && data.msg) || '权限列表获取失败')
                        }
                        _this.permissions = data.data;
                    });
                },
                methods: {
                    dealLock: function (id, lock) {
                        if (!id || lock === undefined) {
                            return false;
                        }
                        let desc = lock === true ? '锁定' : '解锁',
                            _this = this;
                        return AdminBase.warn(`确定${desc}此权限吗?`, function () {
                            $.ajax({
                                url: '/permission_lock_handler',
                                type: 'post',
                                data: {id: id, type: lock ? 1 : 2},
                                headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                                success: (data) => {
                                    if (data.code !== 0 || !data.data || !data.data.id || !data.data.mid) {
                                        return AdminBase.fail(data.msg || `权限${desc}失败`);
                                    }
                                    _this.permissions[data.data.mid]['list'][data.data.id]['is_locked'] = lock | 0;
                                }
                            });
                        })
                    }
                }
            });

    }
});