@extends('admin.index')
@section('head')
    @parent
    <link href="/static/css/news/news_form.css?vt={{time()}}" type="text/css" rel="stylesheet">
@endsection
@section('main-content')
    <section class="content ">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-12">
                        <ol class="breadcrumb float-sm-left">
                            <li class="breadcrumb-item"><a href="/news/news">文档</a></li>
                            <li class="breadcrumb-item active">{{isset($id) ? '修改文档' : '新建文档'}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <form id="news_form_app">
                        <ul class="timeline timeline-inverse" id="news_form_ul">
                            <li class="time-label">
                                <span>文档标题</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <input type="text" class="form-control" v-model="form_data.title">
                                    <span class="form_check_span red">* 必填</span>
                                    <span class="form_check_span grey">* 50字符限制</span>
                                </div>
                            </li>
                            <li class="time-label">
                                <span>关键字</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <input type="text" class="form-control" v-model="form_data.keyword">
                                    <span class="form_check_span orange">* 选填</span>
                                    <span class="form_check_span grey">* 50字符限制</span>
                                    <span class="form_check_span grey">* 多个逗号隔开</span>
                                </div>
                            </li>
                            <li class="time-label">
                                <span>摘要</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <textarea class="form-control" v-model="form_data.abstract"></textarea>
                                    <span class="form_check_span orange">* 选填</span>
                                    <span class="form_check_span grey">* 100字符限制</span>
                                </div>
                            </li>
                            </li>
                            <li class="time-label">
                                <span>索引图</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <div class="timeline-body">
                                        <span class="news-form-index" :title="index_image.title"
                                              @click="triggerFile($event)"
                                              :style="index_image.style"
                                              v-html="index_image.html"></span>
                                        <input type="file" name="index_image" style="display:none"
                                               @change="handleImage($event)">
                                        <span class="form_check_span orange">* 选填</span>
                                        <span class="form_check_span orange">* 最佳宽高比4:3</span>
                                    </div>
                                </div>
                            </li>
                            <li class="time-label">
                                <span>正文</span>
                            </li>
                            <li>
                                <div class="timeline-item bw1">
                                    <div id="toolbar-container"></div>
                                    <div id="editor-container"></div>
                                </div>
                            </li>
                            <li class="time-label">
                                <span class="news_sub cp" @click="formSub">保存</span>
                            </li>
                        </ul>
                    </form>
                </div>
            </div>
        </div>
    </section>
@section('script')
    @parent
    <script>
        let id = '{{isset($id) ? $id : null}}';
    </script>
    <script src="/static/js/ckeditor/ckeditor.js"></script>
    <script src="/static/js/ckeditor/translations/zh-cn.js"></script>
    <script src="/static/js/upload.js?vt={{time()}}"></script>
    <script src="/static/js/ckuploadAdapter.js?vt={{time()}}"></script>
    <script src="/static/js/common/component.js?vt={{time()}}"></script>
    <script src="/static/js/news/news_form.js?vt={{time()}}"></script>
@endsection
@endsection